//
//  CoreInstanceProvider.h
//  dJAX
//
//  Copyright (c) 2014 dJAX. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "Global.h"
#import "URLResolver.h"

@class AdConfiguration;

// Fetching Ads
@class AdServerCommunicator;
@protocol AdServerCommunicatorDelegate;

// URL Handling
@class AdDestinationDisplayAgent;
@protocol AdDestinationDisplayAgentDelegate;

// Utilities
@class AdAlertManager, AdAlertGestureRecognizer;
@class AnalyticsTracker;
@class Reachability;
@class Timer;
@class GeolocationProvider;
@class CLLocationManager;
@class LogEventRecorder;
@class NetworkManager;

typedef id(^MPSingletonProviderBlock)();


typedef NS_OPTIONS(NSUInteger, dJAXATSSetting) {
    MPATSSettingEnabled = 0,
    MPATSSettingAllowsArbitraryLoads = (1 << 0),
    MPATSSettingAllowsArbitraryLoadsForMedia = (1 << 1),
    MPATSSettingAllowsArbitraryLoadsInWebContent = (1 << 2),
    MPATSSettingRequiresCertificateTransparency = (1 << 3),
    MPATSSettingAllowsLocalNetworking = (1 << 4),
};

@interface CoreInstanceProvider : NSObject

+ (instancetype)sharedProvider;
- (id)singletonForClass:(Class)klass provider:(MPSingletonProviderBlock)provider;

- (void)keepObjectAliveForCurrentRunLoopIteration:(id)anObject;

#pragma mark - Fetching Ads
- (NSMutableURLRequest *)buildConfiguredURLRequestWithURL:(NSURL *)URL;
- (AdServerCommunicator *)buildAdServerCommunicatorWithDelegate:(id<AdServerCommunicatorDelegate>)delegate;

#pragma mark - URL Handling
- (URLResolver *)buildURLResolverWithURL:(NSURL *)URL completion:(URLResolverCompletionBlock)completion;
- (AdDestinationDisplayAgent *)buildAdDestinationDisplayAgentWithDelegate:(id<AdDestinationDisplayAgentDelegate>)delegate;

#pragma mark - Utilities
- (UIDevice *)sharedCurrentDevice;
- (GeolocationProvider *)sharedGeolocationProvider;
- (CLLocationManager *)buildCLLocationManager;
- (id<AdAlertManagerProtocol>)buildAdAlertManagerWithDelegate:(id)delegate;
- (AdAlertGestureRecognizer *)buildAdAlertGestureRecognizerWithTarget:(id)target action:(SEL)action;
- (NSOperationQueue *)sharedOperationQueue;
- (AnalyticsTracker *)sharedAnalyticsTracker;
- (Reachability *)sharedReachability;
- (LogEventRecorder *)sharedLogEventRecorder;
- (NetworkManager *)sharedNetworkManager;
- (dJAXATSSetting)appTransportSecuritySettings;

// This call may return nil and may not update if the user hot-swaps the device's sim card.
- (NSDictionary *)sharedCarrierInfo;

- (Timer *)buildTimerWithTimeInterval:(NSTimeInterval)seconds target:(id)target selector:(SEL)selector repeats:(BOOL)repeats;

@end
